#include "csg_structure.h"
#include "AFE_Communication.h"
#include "Meter_Host4481.h"


/////////////////////meter communication packet///////////////////////////////
unsigned char host_command;
afe_msg_t afe_read_message;
unsigned char afe_write_message[5];
unsigned char afe_write_msg_len;
unsigned char afe_write_msg_ptr;
unsigned char afe_read_msg_len;
unsigned char afe_read_msg_ptr;

const unsigned char cal_sequence[] =
{
    AFE_CMD_SET_METER_I1RMS_OFFSET,
    AFE_CMD_SET_METER_I1RMS_GAIN,
    AFE_CMD_SET_METER_P1_GAIN,
    AFE_CMD_SET_METER_P1_PHASE,
    AFE_CMD_SET_METER_P1_OFFSET,
    AFE_CMD_SET_METER_Q1_OFFSET,
    AFE_CMD_SET_METER_I2RMS_OFFSET,
    AFE_CMD_SET_METER_I2RMS_GAIN,
    AFE_CMD_SET_METER_P2_GAIN,
    AFE_CMD_SET_METER_P2_PHASE,
    AFE_CMD_SET_METER_P2_OFFSET,
    AFE_CMD_SET_METER_Q2_OFFSET,
    AFE_CMD_SET_METER_VRMS_GAIN,    
};

const unsigned char reg_sequence[] =
{
    AFE_CMD_SET_METER_SYSCONF,
    AFE_CMD_SET_METER_CSGCONF,
    AFE_CMD_SET_METER_POWER_CONST,
    AFE_CMD_SET_METER_START_CURRENT,    
    AFE_CMD_SET_IE,   
};
///////////////////////////////////////////////////////////////////////
/////////////////////meter communication, use USART////////////////////
///////////////////////////////////////////////////////////////////////
char afe_write_command(char command)
{
    afe_write_message[0] = command;
    afe_write_msg_ptr = 0;
    afe_write_msg_len = 1;

    IE2 |= UTXIE1;

    return  TRUE;
}

char afe_write(int len)
{
    if (len > 5)
        return FALSE;

    P4OUT &= ~BIT2;   //start read

    afe_write_msg_ptr = 0;
    afe_write_msg_len = len;
    gStatus |= ST_AFE_WRITING;

    IE2 &= ~URXIE1;                          // disable host communication RX interrupt to avoid miss AFE sending byte    
    IFG2 |= UTXIFG1;    
    IE2 |= UTXIE1;

    return  TRUE;
}

char prepare_afe_write(unsigned char command, int value, int len)
{
    int i = 0;
    
    afe_write_message[i++] = command;
    if(len != 1){
      afe_write_message[i++] = value&0x00FF;
      afe_write_message[i++] = value>>8;
      afe_write_message[i++] = value&0x00FF;
      afe_write_message[i++] = value>>8;
    }
    return afe_write(len);      
}

////////////////send AFE read command
//when function return, read bytes are stored in afe_read_message and FL_AFE_READ is set
unsigned char verify_checksum()
{
  unsigned char checksum;
  checksum = afe_write_message[0];
  checksum += afe_read_message.uint8[0];
  checksum += afe_read_message.uint8[1];
  checksum += afe_read_message.uint8[2];
  checksum += afe_read_message.uint8[3];
  if(checksum == afe_read_message.uint8[4])
    return 1;
  else
    return 0;
}

char afe_read(unsigned char command)
{

    P4OUT &= ~BIT2;   //start read

    afe_write_message[0] = command;
    afe_write_msg_ptr = 0;
    afe_read_msg_ptr = 0;
    afe_write_msg_len = 1;
    afe_read_msg_len = AFE_READ_PACKET_SIZE;

    gStatus |= ST_AFE_READING;

    CCTL0 = CCIE;                             // CCR0 interrupt enabled to kick off timerout control
    CCR0 = TAR + TIMEROUT_AFE_READ;                // restart timerA
    ME1 &= ~URXE0;                          // disable host communication RX interrupt to avoid miss AFE sending byte
    P1IE = 0x00;                             // disable port interrupt
        
    IFG2 |= UTXIFG1;
    IE2 &= ~URXIE1;                          // disable host communication RX interrupt to avoid miss AFE sending byte    
    IE2 |= UTXIE1;
    
    while(gStatus&ST_AFE_READING);
    
    #ifdef  CHECKSUMUSED
    if(verify_checksum()){
    #endif
      if((gStatus&ST_AFE_READING_TOUT)==0)
        decode_afe_param();
      else
        gStatus &= ~ST_AFE_READING_TOUT;
    #ifdef  CHECKSUMUSED
    }
    #endif

    P1IE|= BIT0 | BIT2 | BIT4;                               // Enable port interrupt again
    ME1 |= URXE0;                          // Enable host communication RX interrupt again
    CCTL0 &= ~CCIE;                           // CCR0 interrupt disabled again

    //for(int i=0; i< 500; i++);
    P4OUT |= BIT2;                            //stop com

//    for(unsigned int i = 0;i<30000;i++);
    
    return  TRUE;
}

////////////////////Read metering parameters
void afe_read_ifg()
{
    afe_read(AFE_CMD_GET_READINGS_IFG);     
}
////////////////////Read metering parameters
void afe_read_params()
{
    afe_read(AFE_CMD_GET_READINGS_P1);
    afe_read(AFE_CMD_GET_READINGS_Q1);    
    afe_read(AFE_CMD_GET_READINGS_P2);
    afe_read(AFE_CMD_GET_READINGS_Q2);    
    afe_read(AFE_CMD_GET_READINGS_S1);    
    afe_read(AFE_CMD_GET_READINGS_S2);    
    afe_read(AFE_CMD_GET_READINGS_VRMS);    
    afe_read(AFE_CMD_GET_READINGS_FREG);    
    afe_read(AFE_CMD_GET_READINGS_I1RMS);    
    afe_read(AFE_CMD_GET_READINGS_I2RMS);   
    afe_read(AFE_CMD_GET_READINGS_PF1);    
    afe_read(AFE_CMD_GET_READINGS_PF2);   
    afe_read(AFE_CMD_GET_READINGS_VDC);  
    afe_read(AFE_CMD_GET_READINGS_I1DC);  
    afe_read(AFE_CMD_GET_READINGS_I2DC);  
}

////////////////////Read meter calibration constant
void afe_read_calibrations()
{
    afe_read(AFE_CMD_GET_METER_I1RMS_OFFSET);
    afe_read(AFE_CMD_GET_METER_I2RMS_OFFSET);
    afe_read(AFE_CMD_GET_METER_I1RMS_GAIN);    
    afe_read(AFE_CMD_GET_METER_I2RMS_GAIN);    
    afe_read(AFE_CMD_GET_METER_P1_GAIN);    
    afe_read(AFE_CMD_GET_METER_P2_GAIN);    
    afe_read(AFE_CMD_GET_METER_P1_PHASE);    
    afe_read(AFE_CMD_GET_METER_P2_PHASE);    
    afe_read(AFE_CMD_GET_METER_P1_OFFSET);    
    afe_read(AFE_CMD_GET_METER_P2_OFFSET);   
    afe_read(AFE_CMD_GET_METER_Q1_OFFSET);    
    afe_read(AFE_CMD_GET_METER_Q2_OFFSET);       
    afe_read(AFE_CMD_GET_METER_VRMS_GAIN);   
    afe_read(AFE_CMD_GET_READINGS_CHECKSUM1);           
}
void afe_read_configurations()
{
    afe_read(AFE_CMD_GET_METER_SYSCONF);
    afe_read(AFE_CMD_GET_METER_CSGCONF);
    afe_read(AFE_CMD_GET_METER_POWER_CONST);    
    afe_read(AFE_CMD_GET_METER_START_CURRENT);    
    afe_read(AFE_CMD_GET_READINGS_IE);    
    afe_read(AFE_CMD_GET_READINGS_STATUS);  
    afe_read(AFE_CMD_GET_READINGS_WREN);  
    afe_read(AFE_CMD_GET_READINGS_METER_STATUS);      
}
//////////////////////////set AFE regisiters////////////////////////
void afe_set_calibrations()
{
  unsigned int i;
  unsigned char j;
  int16_t *old_cal;
  int16_t *new_cal;
  
  old_cal = (int16_t *)phase_nv;
  new_cal = (int16_t *)phase_nv_new;
  for(j=0 ; j<13; j++)
  {
    if( new_cal[j] != old_cal[j]){
      prepare_afe_write(AFE_CMD_SET_WREN, AFE_WREN, 5); 
      for(i = 0; i<8000; i++);  //6000 count delay 10ms at 4MHz MCLK. At least 7000 count needed to garentee successful operation.
      prepare_afe_write(cal_sequence[j], new_cal[j], 5); 
      for(i = 0; i<42000; i++); //50ms delay at 4MHz MCLK. AFE flash writing needs around 36ms.
    }
  }
}

void afe_set_registers()
{
  unsigned int i;
  unsigned char j;
  int16_t *old_cal;
  int16_t *new_cal;
  
  old_cal = (int16_t *)phase_conf;
  new_cal = (int16_t *)phase_conf_new;
  for(j=0 ; j<5; j++)
  {
    if( new_cal[j] != old_cal[j]){
      prepare_afe_write(AFE_CMD_SET_WREN, AFE_WREN_REG, 5); 
      for(i = 0; i<8000; i++);  //6000 count delay 10ms at 4MHz MCLK. At least 7000 count needed to garentee successful operation.
      prepare_afe_write(reg_sequence[j], new_cal[j], 5); 
      for(i = 0; i<8000; i++); //6000 count delay 10ms at 4MHz MCLK. At least 7000 count needed to garentee successful operation.
    }
  }
}

void afe_softreset()
{
  prepare_afe_write(AFE_CMD_SET_SRST, 0x0099, 5); 
  for(int i = 0; i<8000; i++);  //6000 count delay 10ms at 4MHz MCLK. At least 7000 count needed to garentee successful operation.
}
///////////////////////////////////////////////////////////////////////////
void decode_afe_param()
{
    unsigned long highword, lowword;
  
    switch (afe_write_message[0])
    {
#if 1      
    case AFE_CMD_GET_METER_EMPTY:
      break;
    case AFE_CMD_GET_METER_SYSCONF:
      phase_conf->gSysconf = afe_read_message.uint16[0];
      break;
    case AFE_CMD_GET_METER_CSGCONF:
      phase_conf->gCsgconf = afe_read_message.uint16[0];
      break;
    case AFE_CMD_GET_METER_POWER_CONST:
      phase_conf->gPower_const = afe_read_message.uint16[0];
      break;
    case AFE_CMD_GET_METER_START_CURRENT:
      phase_conf->gStart_curr = afe_read_message.uint16[0];
      break;
      
    case AFE_CMD_GET_METER_I1RMS_OFFSET:
      phase_nv->current[0].Ac_offset = afe_read_message.uint16[0];
      break;
    case AFE_CMD_GET_METER_I2RMS_OFFSET:
      phase_nv->current[1].Ac_offset = afe_read_message.uint16[0];
      break;
    case AFE_CMD_GET_METER_I1RMS_GAIN:
      phase_nv->current[0].I_rms_scale_factor[0] = afe_read_message.uint16[0];
      break;
    case AFE_CMD_GET_METER_I2RMS_GAIN:
      phase_nv->current[1].I_rms_scale_factor[0] = afe_read_message.uint16[0];
      break;
    case AFE_CMD_GET_METER_P1_GAIN:
      phase_nv->current[0].P_scale_factor[0] = afe_read_message.uint16[0];
      break;
    case AFE_CMD_GET_METER_P2_GAIN:
      phase_nv->current[1].P_scale_factor[0] = afe_read_message.uint16[0];
      break;
    case AFE_CMD_GET_METER_P1_PHASE:
      phase_nv->current[0].Phase_correction[0] = afe_read_message.uint16[0];
      break;
    case AFE_CMD_GET_METER_P2_PHASE:
      phase_nv->current[1].Phase_correction[0] = afe_read_message.uint16[0];
      break;
    case AFE_CMD_GET_METER_P1_OFFSET:
      phase_nv->current[0].Offset_active_power = afe_read_message.uint16[0];
      break;
    case AFE_CMD_GET_METER_P2_OFFSET:
      phase_nv->current[1].Offset_active_power = afe_read_message.uint16[0];
      break;
    case AFE_CMD_GET_METER_Q1_OFFSET:
      phase_nv->current[0].Offset_reactive_power = afe_read_message.uint16[0];
      break;
    case AFE_CMD_GET_METER_Q2_OFFSET:
      phase_nv->current[1].Offset_reactive_power = afe_read_message.uint16[0];
      break;
    case AFE_CMD_GET_METER_VRMS_GAIN:
      phase_nv->V_rms_scale_factor = afe_read_message.uint16[0];
      break;
    //V5  
    case AFE_CMD_GET_READINGS_VDC:
      lowword = afe_read_message.uint16[0];
      highword =afe_read_message.uint16[1];
      phase->V_dc_estimate = lowword | (((long)highword<<16)&0xFFFF0000);
      break;           
    case AFE_CMD_GET_READINGS_I1DC:
      lowword = afe_read_message.uint16[0];
      highword =afe_read_message.uint16[1];
      phase->I_dc_estimate[0] = lowword | (((long)highword<<16)&0xFFFF0000);
      break;           
    case AFE_CMD_GET_READINGS_I2DC:
      lowword = afe_read_message.uint16[0];
      highword =afe_read_message.uint16[1];
      phase->I_dc_estimate[1] = lowword | (((long)highword<<16)&0xFFFF0000);
      break;                 
//////////////////////////////////////////////////////////////////////////////////
    case AFE_CMD_GET_READINGS_P1:
      lowword = afe_read_message.uint16[0];
      highword =afe_read_message.uint16[1];
      phase->active_power[0] = lowword | ((highword<<16)&0xFFFF0000);
      break;       
    case AFE_CMD_GET_READINGS_P2:
      lowword = afe_read_message.uint16[0];
      highword =afe_read_message.uint16[1];
      phase->active_power[1] = lowword | ((highword<<16)&0xFFFF0000);
      break;         
    case AFE_CMD_GET_READINGS_Q1:
      lowword = afe_read_message.uint16[0];
      highword =afe_read_message.uint16[1];
      phase->reactive_power[0] = lowword | ((highword<<16)&0xFFFF0000);
      break;                
    case AFE_CMD_GET_READINGS_Q2:
      lowword = afe_read_message.uint16[0];
      highword =afe_read_message.uint16[1];
      phase->reactive_power[1] = lowword | ((highword<<16)&0xFFFF0000);
      break;                  
    case AFE_CMD_GET_READINGS_S1:
      lowword = afe_read_message.uint16[0];
      highword =afe_read_message.uint16[1];
      phase->apparent_power[0] = lowword | ((highword<<16)&0xFFFF0000);
      break;                       
    case AFE_CMD_GET_READINGS_S2:
      lowword = afe_read_message.uint16[0];
      highword =afe_read_message.uint16[1];
      phase->apparent_power[1] = lowword | ((highword<<16)&0xFFFF0000);
      break;                       
    case AFE_CMD_GET_READINGS_VRMS:
      lowword = afe_read_message.uint16[0];
      highword =afe_read_message.uint16[1];
      phase->V_rms = lowword;
      break;                           
    case AFE_CMD_GET_READINGS_FREG:
      lowword = afe_read_message.uint16[0];
      highword =afe_read_message.uint16[1];
      phase->frequency = lowword;
      break;                           
    case AFE_CMD_GET_READINGS_I1RMS:
      lowword = afe_read_message.uint16[0];
      highword =afe_read_message.uint16[1];
      phase->I_rms[0] = lowword;
      break;                           
    case AFE_CMD_GET_READINGS_I2RMS:
      lowword = afe_read_message.uint16[0];
      highword =afe_read_message.uint16[1];
      phase->I_rms[1] = lowword;
      break;                           
    case AFE_CMD_GET_READINGS_PF1:
      lowword = afe_read_message.uint16[0];
      highword =afe_read_message.uint16[1];
      phase->power_factor[0] = lowword;
      break;                           
    case AFE_CMD_GET_READINGS_PF2:
      lowword = afe_read_message.uint16[0];
      highword =afe_read_message.uint16[1];
      phase->power_factor[1] = lowword;
      break;  
    case AFE_CMD_GET_READINGS_ACTENERGY1:
      lowword = afe_read_message.uint16[0];
      highword =afe_read_message.uint16[1];
      phase->energy.total_consumed_energy = lowword | (((long)highword<<16)&0xFFFF0000);
      break;            
    case AFE_CMD_GET_READINGS_REACTENERGY1:
      lowword = afe_read_message.uint16[0];
      highword =afe_read_message.uint16[1];
      phase->energy.total_consumed_reactive_energy = lowword | (((long)highword<<16)&0xFFFF0000);
      break;     
      //V5
    case AFE_CMD_GET_READINGS_NEGTIVE_ACTENERGY1:
      lowword = afe_read_message.uint16[0];
      highword =afe_read_message.uint16[1];
      phase->energy.total_consumed_negtive_energy = lowword | (((long)highword<<16)&0xFFFF0000);
      break;            
    case AFE_CMD_GET_READINGS_NEGTIVE_REACTENERGY1:
      lowword = afe_read_message.uint16[0];
      highword =afe_read_message.uint16[1];
      phase->energy.total_consumed_negtive_reactive_energy = lowword | (((long)highword<<16)&0xFFFF0000);
      break;       
//////////////////////////READ ie, status...      
    case AFE_CMD_GET_READINGS_IE:
      phase_conf->int_enable = afe_read_message.uint8[0];
      break;     
    case AFE_CMD_GET_READINGS_IFG:
      phase_conf->int_flag = afe_read_message.uint8[0];
      break;     
    case AFE_CMD_GET_READINGS_STATUS:
      phase_conf->status = afe_read_message.uint16[0];
      break;  
    case AFE_CMD_GET_READINGS_CHECKSUM1:
      phase_conf->chksum1 = afe_read_message.uint16[0];
      break;            
    case AFE_CMD_GET_READINGS_WREN:
      phase_conf->wren = afe_read_message.uint16[0];
      break;        
    case AFE_CMD_GET_READINGS_METER_STATUS:
      meter1.meter_status = afe_read_message.uint16[0];
      break;                 
#endif      
      
////////////////////////////////////////////////////////////////////////////////////////
    case AFE_CMD_SET_METER_I1RMS_OFFSET:
    case AFE_CMD_SET_METER_I2RMS_OFFSET:
      break;
    case AFE_CMD_SET_METER_I1RMS_GAIN:
    case AFE_CMD_SET_METER_I2RMS_GAIN:
      break;
    case AFE_CMD_SET_METER_P1_GAIN:     
    case AFE_CMD_SET_METER_P2_GAIN:
      break;
    case AFE_CMD_SET_METER_P1_PHASE:
    case AFE_CMD_SET_METER_P2_PHASE:
      break;      
    case AFE_CMD_SET_METER_P1_OFFSET:
    case AFE_CMD_SET_METER_P2_OFFSET:
      break;      
    case AFE_CMD_SET_METER_Q1_OFFSET:
    case AFE_CMD_SET_METER_Q2_OFFSET:
      break;
    case AFE_CMD_SET_METER_VRMS_GAIN:
      break;     
        
    default:
        break;
    }  
}